/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.steps.VWParticipantsPanel;
import filenet.vw.toolkit.utils.dialog.VWUsersDialog;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.uicontrols.security.IVWParticipantSelectionDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class VWParticipantsDialog
extends VWUsersDialog
implements IVWParticipantSelectionDialog,
ActionListener {
    private JRadioButton m_groupsRadioButton = null;
    private JRadioButton m_usersRadioButton = null;
    private boolean m_bShowParticipants = true;

    public VWParticipantsDialog(Frame parent, VWSession vwSession) {
        super(parent, vwSession);
    }

    public VWParticipantsDialog(Frame parent, VWSession vwSession, boolean bShowParticipants) {
        super(parent, vwSession);
        this.m_bShowParticipants = bShowParticipants;
    }

    public void init(VWParticipantItem[] vwParticipantItems, VWParticipantItem[] wflGroupList) throws VWException {
        if (!this.m_layout) {
            this.layoutControls();
            this.m_layout = true;
        }
        if (this.m_usersGroupsPanel != null && this.m_usersGroupsPanel instanceof VWParticipantsPanel) {
            ((VWParticipantsPanel)this.m_usersGroupsPanel).init(vwParticipantItems, wflGroupList);
        }
        this.m_status = 2;
        if (!this.m_bShowParticipants) {
            this.m_usersRadioButton.setEnabled(false);
        }
        if (this.m_usersGroupsPanel != null && ((VWParticipantsPanel)this.m_usersGroupsPanel).hasWorkflowGroups()) {
            this.m_groupsRadioButton.setSelected(true);
            this.resetListFilter(0);
        } else {
            this.m_usersRadioButton.setSelected(true);
            this.resetListFilter(1);
        }
    }

    public void init(VWParticipantItem[] vwParticipantItems, String wflGroupName) throws VWException {
        throw new VWException("filenet.vw.toolkit.utils.uicontrols.security.invalidMethod", "Invalid method!");
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source == this.m_groupsRadioButton) {
                this.resetListFilter(0);
            } else if (source == this.m_usersRadioButton) {
                this.resetListFilter(1);
            } else {
                super.actionPerformed(event);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void initializeContentPane() {
        JPanel filterPanel = null;
        ButtonGroup filterGroup = null;
        try {
            filterPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            this.m_groupsRadioButton = new JRadioButton(VWResource.s_workflowGroupsStr);
            this.m_groupsRadioButton.addActionListener(this);
            this.m_usersRadioButton = new JRadioButton(VWResource.s_users);
            this.m_usersRadioButton.addActionListener(this);
            filterGroup = new ButtonGroup();
            filterGroup.add(this.m_groupsRadioButton);
            filterGroup.add(this.m_usersRadioButton);
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(3, 3, 0, 2);
            gbCons.anchor = 23;
            gbCons.fill = 0;
            filterPanel.add((Component)new JLabel(VWResource.s_showAvailable), gbCons);
            gbCons.gridx = 1;
            gbCons.gridy = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 0, 0, 0);
            gbCons.anchor = 23;
            gbCons.fill = 0;
            filterPanel.add((Component)this.m_groupsRadioButton, gbCons);
            gbCons.gridx = 2;
            gbCons.gridy = 0;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 0, 0, 0);
            gbCons.anchor = 23;
            gbCons.fill = 2;
            filterPanel.add((Component)this.m_usersRadioButton, gbCons);
            this.getContentPane().add((Component)filterPanel, "First");
            this.m_usersGroupsPanel = new VWParticipantsPanel(this, this.m_vwSession);
            this.m_usersGroupsPanel.enableSorting(1536);
            this.getContentPane().add((Component)this.m_usersGroupsPanel, "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void resetListFilter(int nType) {
        if (this.m_usersGroupsPanel != null && this.m_usersGroupsPanel instanceof VWParticipantsPanel) {
            ((VWParticipantsPanel)this.m_usersGroupsPanel).refreshLists(nType);
        }
    }
}

